//
// Copyright 2021 New Vector Ltd
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

import Foundation

protocol AuthenticationVerifyMsisdnViewModelProtocol {
    var callback: (@MainActor (AuthenticationVerifyMsisdnViewModelResult) -> Void)? { get set }
    var context: AuthenticationVerifyMsisdnViewModelType.Context { get }
    
    /// Updates the view to reflect that a verification SMS was successfully sent.
    @MainActor func updateForSentSMS()

    //  Goes back to the msisdn form
    @MainActor func goBackToMsisdnForm()
    
    /// Display an error to the user.
    @MainActor func displayError(_ type: AuthenticationVerifyMsisdnErrorType)
}
