/*
 Copyright 2019 New Vector Ltd
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

import Foundation

protocol KeyBackupRecoverFromPassphraseViewModelViewDelegate: AnyObject {
    func keyBackupRecoverFromPassphraseViewModel(_ viewModel: KeyBackupRecoverFromPassphraseViewModelType, didUpdateViewState viewSate: KeyBackupRecoverFromPassphraseViewState)
}

protocol KeyBackupRecoverFromPassphraseViewModelCoordinatorDelegate: AnyObject {
    func keyBackupRecoverFromPassphraseViewModelDidRecover(_ viewModel: KeyBackupRecoverFromPassphraseViewModelType)
    func keyBackupRecoverFromPassphraseViewModelDidCancel(_ viewModel: KeyBackupRecoverFromPassphraseViewModelType)
    func keyBackupRecoverFromPassphraseViewModelDoNotKnowPassphrase(_ viewModel: KeyBackupRecoverFromPassphraseViewModelType)
}

/// Protocol describing the view model used by `KeyBackupRecoverFromPassphraseViewController`
protocol KeyBackupRecoverFromPassphraseViewModelType {
    
    var passphrase: String? { get set }
    var isFormValid: Bool { get }
    
    var viewDelegate: KeyBackupRecoverFromPassphraseViewModelViewDelegate? { get set }
    var coordinatorDelegate: KeyBackupRecoverFromPassphraseViewModelCoordinatorDelegate? { get set }
    
    func process(viewAction: KeyBackupRecoverFromPassphraseViewAction)
}
