// File created from ScreenTemplate
// $ createScreen.sh Contacts ContactDetails
/*
 Copyright 2021 New Vector Ltd
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

import Foundation
import UIKit

final class ContactDetailsCoordinator: ContactDetailsCoordinatorProtocol {
    
    // MARK: - Properties
    
    // MARK: Private
    
    private let parameters: ContactDetailsCoordinatorParameters
    private let contactDetailsViewController: ContactDetailsViewController
    
    // MARK: Public

    // Must be used only internally
    var childCoordinators: [Coordinator] = []
    
    weak var delegate: ContactDetailsCoordinatorDelegate?
    
    // MARK: - Setup
    
    init(parameters: ContactDetailsCoordinatorParameters) {
        self.parameters = parameters
        let contactDetailsViewController: ContactDetailsViewController = ContactDetailsViewController.instantiate()
        contactDetailsViewController.contact = self.parameters.contact
        contactDetailsViewController.enableVoipCall = self.parameters.enableVoipCall
        self.contactDetailsViewController = contactDetailsViewController
    }
    
    // MARK: - Public
    
    func start() {
    }
    
    func toPresentable() -> UIViewController {
        return self.contactDetailsViewController
    }
}
