// 
// Copyright 2021 New Vector Ltd
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

import Foundation
import UIKit

/**
 Struct for holding colour values for a particular theme.
 */
public struct ColorValues: Colors {
    
    public let accent: UIColor
    
    public let alert: UIColor
    
    public let primaryContent: UIColor
    
    public let secondaryContent: UIColor
    
    public let tertiaryContent: UIColor
    
    public let quarterlyContent: UIColor
    
    public let quinaryContent: UIColor
    
    public let separator: UIColor
    
    public let system: UIColor
    
    public let tile: UIColor
    
    public let navigation: UIColor
    
    public let background: UIColor
    
    public let ems: UIColor
    
    public let links: UIColor
    
    public let namesAndAvatars: [UIColor]
}
