/*
 * Copyright (c) 2022 New Vector Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package im.vector.app.test.fixtures

import im.vector.app.features.analytics.AnalyticsConfig

object AnalyticsConfigFixture {
    fun anAnalyticsConfig(
            isEnabled: Boolean = false,
            postHogHost: String = "http://posthog.url",
            postHogApiKey: String = "api-key",
            policyLink: String = "http://policy.link",
            sentryDSN: String = "http://sentry.dsn",
            sentryEnvironment: String = "sentry-env"
    ) = AnalyticsConfig(isEnabled, postHogHost, postHogApiKey, policyLink, sentryDSN, sentryEnvironment)
}
