/*
 * Copyright (c) 2020 New Vector Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package im.vector.app.features.userdirectory

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class UserListFragmentArgs(
        val title: String,
        val menuResId: Int,
        val submitMenuItemId: Int,
        val excludedUserIds: Set<String>? = null,
        val singleSelection: Boolean = false,
        val showInviteActions: Boolean = true,
        val showContactBookAction: Boolean = true,
        val showToolbar: Boolean = true
) : Parcelable
