/*
 * Copyright (c) 2021 The Matrix.org Foundation C.I.C.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.matrix.android.sdk.internal.crypto.verification

import org.matrix.android.sdk.internal.crypto.tasks.SendToDeviceTask
import org.matrix.android.sdk.internal.di.DeviceId
import org.matrix.android.sdk.internal.task.TaskExecutor
import org.matrix.android.sdk.internal.util.time.Clock
import javax.inject.Inject

internal class VerificationTransportToDeviceFactory @Inject constructor(
        private val sendToDeviceTask: SendToDeviceTask,
        @DeviceId val myDeviceId: String?,
        private val taskExecutor: TaskExecutor,
        private val clock: Clock,
) {

    fun createTransport(tx: DefaultVerificationTransaction?): VerificationTransportToDevice {
        return VerificationTransportToDevice(tx, sendToDeviceTask, myDeviceId, taskExecutor, clock)
    }
}
