/*
 * Copyright (c) 2020 New Vector Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package im.vector.app.features.share

import im.vector.app.core.platform.VectorViewModelAction
import org.matrix.android.sdk.api.session.room.model.RoomSummary

sealed class IncomingShareAction : VectorViewModelAction {
    data class SelectRoom(val roomSummary: RoomSummary, val enableMultiSelect: Boolean) : IncomingShareAction()
    object ShareToSelectedRooms : IncomingShareAction()
    data class ShareToRoom(val roomSummary: RoomSummary) : IncomingShareAction()
    data class ShareMedia(val keepOriginalSize: Boolean) : IncomingShareAction()
    data class FilterWith(val filter: String) : IncomingShareAction()
    data class UpdateSharedData(val sharedData: SharedData) : IncomingShareAction()
}
